<?php
$nameplate = '';
$url = "../admin/";
$cars_search = null; // Initialize $cars_search variable outside of the if block

// Remove non-numeric characters from the input nameplate
        $input_nameplate = preg_replace("/[^0-9]/", "", $_REQUEST["nameplate"]);

        // Use prepared statement to prevent SQL injection
        $sql_search = mysqli_prepare($connect, "SELECT * FROM cars");
        mysqli_stmt_execute($sql_search);
        $result_search = mysqli_stmt_get_result($sql_search);

        while ($row = mysqli_fetch_assoc($result_search)) {
                $cars_search[] = $row;
            }
        
?>

    <!-- Show the container only when the submit button is pressed -->
    <?php if (!empty($cars_search)) : ?>
        <!-- Show cars if found -->
        <div class="container">
            <div class="col-xl-12 col-lg-12 col-md-12 col-12">
                <div class="row">
                    <?php foreach ($cars_search as $car) : ?>
                        <div class="col-xl-6 col-lg-6 col-sm-6 col-12">
                            <a href="booknow.php?id=<?php echo $car['car_id'] ?>">
                                <div class="ctm-border-radius shadow-sm card">
                                    <div class="card-body">
                                        <img class="card-img-top" style="width: 500px;" src="<?php echo $url . $car['car_img']; ?>" alt="Card image cap"></br></br>
                                        <center>
                                            <h3> Model &nbsp; <?php echo $car['model']; ?></h3>
                                        </center>
                                        <div class="card-footer">
                                            <center>
                                                <h2 class="page-sub-title d-inline-block mb-0 mt-2"><?php echo $car['car_name']; ?>&nbsp;(<?php echo $car['car_nameplate']; ?>) </h2>
                                            </center>
                                        </div>
                                    </div>
                                </div>
                            </a>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    <?php else : ?>
        <!-- Show "No cars available" message if no cars are found -->
            <div class="col-xl-12 col-lg-12 col-md-12 col-12">
                <div class="row">
                    <div class="col-12">
                        <div class="alert alert-info text-center" role="alert">
                            <h5>No Car Found</h5>
                        </div>
                    </div>
                </div>
            </div>
    <?php endif; ?>

